document.addEventListener("DOMContentLoaded", async () => {
    const tableBody = document.getElementById("work-hours-table");
    const workerDropdown = document.getElementById("worker-dropdown");
    const fetchWorkerHoursBtn = document.getElementById("fetch-worker-hours");
    const clockInBtn = document.getElementById("clock-in-btn");
    const clockOutBtn = document.getElementById("clock-out-btn");
    const ownerControls = document.getElementById("owner-controls");
    const workerActions = document.getElementById("worker-actions");

    // Funkcija, lai iegūtu lietotāja lomu
    const fetchUserRole = async () => {
        try {
            const response = await fetch("../php/get-user-role.php");
            const result = await response.json();
            return result.role;
        } catch (error) {
            console.error("Kļūda, iegūstot lietotāja lomu:", error);
            return null;
        }
    };

    // Funkcija, lai iegūtu darbiniekus nolaižamajā izvēlnē
    const fetchWorkers = async () => {
        try {
            const response = await fetch("../php/owner-work-hours.php?action=fetch-workers");
            const result = await response.json();
            if (result.data) {
                populateDropdown(result.data);
            } else if (result.error) {
                alert(result.error);
            }
        } catch (error) {
            console.error("Kļūda, iegūstot darbiniekus:", error);
        }
    };

    // Funkcija, lai aizpildītu nolaižamo izvēlni ar darbiniekiem
    const populateDropdown = (workers) => {
        workerDropdown.innerHTML = '<option value="">-- Izvēlieties darbinieku --</option>';
        workers.forEach(worker => {
            const option = document.createElement("option");
            option.value = worker.id;
            option.textContent = `${worker.first_name} ${worker.last_name}`;
            workerDropdown.appendChild(option);
        });
    };

    // Funkcija, lai iegūtu un attēlotu darba stundas
    const fetchWorkHours = async (workerId = null) => {
        const url = workerId
            ? `../php/owner-work-hours.php?action=fetch-work-hours&worker_id=${workerId}`
            : "../php/work-hours.php?action=fetch-work-hours";

        try {
            const response = await fetch(url);
            const result = await response.json();
            renderTable(result.data || []);
        } catch (error) {
            console.error("Kļūda, iegūstot darba stundas:", error);
        }
    };

    // Funkcija, lai attēlotu darba stundas tabulā
    const renderTable = (data) => {
        tableBody.innerHTML = "";
        if (data.length === 0) {
            tableBody.innerHTML = "<tr><td colspan='4'>Darba stundas nav reģistrētas.</td></tr>";
            return;
        }
        data.forEach(row => {
            const tr = document.createElement("tr");
            tr.innerHTML = `
                <td>${row.date || "Nav pieejams"}</td>
                <td>${row.clock_in_time || "Nav pieejams"}</td>
                <td>${row.clock_out_time || "Nav pieejams"}</td>
                <td>${row.total_work_hours || "Nav pieejams"}</td>`;
            tableBody.appendChild(tr);
        });
    };

    // Funkcija, lai apstrādātu ieslēgšanās/izslēgšanās darbības darbiniekiem
    const handleClockAction = async (action) => {
        try {
            const response = await fetch("../php/work-hours.php", {
                method: "POST",
                body: new URLSearchParams({ action }),
            });
            const result = await response.json();
            if (result.success) {
                alert(result.success);
                fetchWorkHours();
            } else if (result.error) {
                alert(result.error);
            }
        } catch (error) {
            console.error(`Kļūda, izpildot ${action}:`, error);
        }
    };

    // Inicializācija atbilstoši lietotāja lomai
    const role = await fetchUserRole();
    if (role === "darbinieks") {
        workerActions.style.display = "block";
        fetchWorkHours();

        clockInBtn.addEventListener("click", () => handleClockAction("clock-in"));
        clockOutBtn.addEventListener("click", () => handleClockAction("clock-out"));
    } else if (role === "valdes_loceklis") {
        ownerControls.style.display = "block";
        fetchWorkers();

        fetchWorkerHoursBtn.addEventListener("click", () => {
            const selectedWorkerId = workerDropdown.value;
            if (selectedWorkerId) {
                fetchWorkHours(selectedWorkerId);
            } else {
                alert("Lūdzu, izvēlieties darbinieku.");
            }
        });
    }
});